/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.common;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.event.EventMessage;
import jtbcore.event.MessageBus;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.AppLogger;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.ObjectUtil;
import jtbcore.util.StringUtil;

public abstract class SqlConnection {
    protected Connection connection;
    protected boolean autoTruncate = false;
    protected char START_VAL = (char)96;
    protected char STOP_VAL = (char)96;
    protected Integer resultSetType = null;
    protected Integer resultSetConcur = null;
    protected int transactionCounter = 0;
    protected PreparedStatement lastPreparedStatement = null;

    public abstract SqlDatabase getSqlDatabase() throws IOException, SQLException;

    public abstract void updateTable(TableModel var1) throws SQLException, IOException;

    public abstract void resetSqlDatabase();

    public abstract void initModel(DatabaseModel var1) throws SQLException, IOException;

    public abstract Integer insertQuery(String var1, Object ... var2) throws SQLException;

    public boolean isAutoTruncate() {
        return this.autoTruncate;
    }

    public void setAutoTruncate(boolean autoTruncate) {
        this.autoTruncate = autoTruncate;
    }

    public char getStartVal() {
        return this.START_VAL;
    }

    public char getStopVal() {
        return this.STOP_VAL;
    }

    public String applyStartStop(String s) {
        return this.START_VAL + s + this.STOP_VAL;
    }

    public String encloseCol(String colname) {
        if (colname == null || colname.length() == 0) {
            return colname;
        }
        if (colname.charAt(0) == this.START_VAL || colname.charAt(colname.length() - 1) == this.STOP_VAL) {
            return colname;
        }
        return this.START_VAL + colname + this.STOP_VAL;
    }

    public boolean isFordwardOnly() {
        return this.resultSetType == null || this.resultSetType == 1003;
    }

    public void startTransaction() throws SQLException {
        if (this.transactionCounter == 0) {
            this.connection.setAutoCommit(false);
        }
        ++this.transactionCounter;
    }

    public void commit() throws SQLException {
        if (this.transactionCounter == 0) {
            throw new SQLException("Not in a transaction");
        }
        --this.transactionCounter;
        if (this.transactionCounter == 0) {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
    }

    public void rollback() throws SQLException {
        if (this.transactionCounter == 0) {
            throw new SQLException("Not in a transaction");
        }
        this.transactionCounter = 0;
        this.connection.rollback();
        this.connection.setAutoCommit(true);
    }

    public PreparedStatement prepareStatement(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        int x = 0;
        while (x < args.length) {
            ps.setObject(x + 1, args[x]);
            ++x;
        }
        return ps;
    }

    public BaseStringMap queryStringMap(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.prepareStatement(sql, args);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            BaseStringMap m = new BaseStringMap();
            int colCount = rs.getMetaData().getColumnCount();
            int colNo = 1;
            while (colNo <= colCount) {
                String colName = rs.getMetaData().getColumnName(colNo);
                m.setProperty(colName, rs.getString(colNo));
                ++colNo;
            }
            rs.close();
            ps.close();
            return m;
        }
        return null;
    }

    public static BaseStringMap resultSet2StringMap(ResultSet rs) throws SQLException {
        BaseStringMap m = new BaseStringMap();
        int colCount = rs.getMetaData().getColumnCount();
        int colNo = 1;
        while (colNo <= colCount) {
            String colName = rs.getMetaData().getColumnName(colNo);
            m.setProperty(colName, rs.getString(colNo));
            ++colNo;
        }
        return m;
    }

    public Object queryValue(String sql, Class clazz, Object ... args) throws SQLException {
        PreparedStatement ps = this.prepareStatement(sql, args);
        Object r = null;
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            if (clazz != null) {
                if (clazz == Integer.class) {
                    r = rs.getInt(1);
                } else if (clazz == Long.class) {
                    r = rs.getLong(1);
                } else if (clazz == Float.class) {
                    r = Float.valueOf(rs.getFloat(1));
                } else if (clazz == Double.class) {
                    r = rs.getDouble(1);
                } else if (clazz == String.class) {
                    r = rs.getString(1);
                } else if (clazz == BigDecimal.class) {
                    r = rs.getBigDecimal(1);
                } else if (clazz == Date.class) {
                    r = rs.getDate(1);
                } else if (clazz == java.util.Date.class) {
                    Date d = rs.getDate(1);
                    if (d != null) {
                        r = new java.util.Date(d.getTime());
                    }
                } else {
                    r = rs.getObject(1);
                }
            } else {
                r = rs.getObject(1);
            }
        }
        rs.close();
        ps.close();
        return r;
    }

    public Long queryLong(String sql, Object ... args) throws SQLException {
        return (Long)this.queryValue(sql, Long.class, args);
    }

    public Integer queryInteger(String sql, Object ... args) throws SQLException {
        return (Integer)this.queryValue(sql, Integer.class, args);
    }

    public PreparedStatement _insertQuery(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql, 1);
        int x = 0;
        while (x < args.length) {
            ps.setObject(x + 1, args[x]);
            ++x;
        }
        ps.execute();
        return ps;
    }

    public List queryList(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        int x = 0;
        while (x < args.length) {
            ps.setObject(x + 1, args[x]);
            ++x;
        }
        ResultSet rs = ps.executeQuery();
        int colCount = rs.getMetaData().getColumnCount();
        String[] colNames = new String[colCount];
        int x2 = 0;
        while (x2 < colCount) {
            colNames[x2] = rs.getMetaData().getColumnName(x2 + 1);
            ++x2;
        }
        ArrayList<BaseStringMap> records = new ArrayList<BaseStringMap>();
        while (rs.next()) {
            BaseStringMap m = new BaseStringMap();
            int x3 = 0;
            while (x3 < colCount) {
                Object val = rs.getObject(x3 + 1);
                if (val != null) {
                    val = val.toString();
                }
                m.setProperty(colNames[x3], (String)val);
                ++x3;
            }
            records.add(m);
        }
        return records;
    }

    public Map<String, BaseStringMap> queryMap(String keyCol, String sql, Object ... args) throws SQLException {
        List records = this.queryList(sql, args);
        HashMap<String, BaseStringMap> r = new HashMap<String, BaseStringMap>();
        for (BaseStringMap m : records) {
            String key = m.getProperty(keyCol);
            r.put(key, m);
        }
        return r;
    }

    public Object castColValue(SqlColumn sqlCol, String colval) {
        if (colval == null) {
            return colval;
        }
        if (sqlCol.internalType == SqlColumn.DataType.BOOLEAN) {
            if ("true".equalsIgnoreCase(colval) || "1".equals(colval)) {
                return 1;
            }
            return 0;
        }
        if (sqlCol.internalType == SqlColumn.DataType.NUMERIC) {
            return NumberUtil.tryParseLong(colval);
        }
        if (sqlCol.internalType == SqlColumn.DataType.REAL) {
            return NumberUtil.tryParseDouble(colval);
        }
        if (sqlCol.internalType == SqlColumn.DataType.TEXT) {
            return colval.toString();
        }
        if (sqlCol.internalType == SqlColumn.DataType.DATE) {
            return DateUtil.string2datetime(colval);
        }
        return colval;
    }

    public Integer insertRecord(String table, BaseStringMap map) throws IOException, SQLException {
        SqlTable sqlTable = this.getSqlDatabase().getTable(table);
        SqlTable tbl = this.getSqlDatabase().getTable(table);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder str = new StringBuilder();
        str.append("INSERT INTO ").append(tbl.getTableRef());
        str.append(" (");
        Set<String> keys = map.getMap().keySet();
        int colCount = 0;
        for (String k : keys) {
            int maxColLen;
            SqlColumn sqlCol = tbl.getColumn(k);
            if (sqlCol == null) continue;
            if (colCount > 0) {
                str.append(", ");
            }
            str.append(this.START_VAL).append(sqlCol.name).append(this.STOP_VAL);
            String colval = map.getProperty(k);
            if (colval != null && this.autoTruncate && (maxColLen = sqlTable.getColumnByName((String)k).maxLen) != -1 && colval.length() > maxColLen) {
                colval = colval.substring(0, maxColLen);
            }
            params.add(this.castColValue(tbl.getColumn(k), colval));
            ++colCount;
        }
        str.append(") ");
        str.append("VALUES (");
        int x = 0;
        while (x < colCount) {
            if (x > 0) {
                str.append(", ");
            }
            str.append("?");
            ++x;
        }
        str.append(")");
        return this.insertQuery(str.toString(), params.toArray());
    }

    public boolean query(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        int x = 0;
        while (x < args.length) {
            ps.setObject(x + 1, args[x]);
            ++x;
        }
        boolean r = ps.execute();
        ps.close();
        return r;
    }

    public int queryUpdate(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        int x = 0;
        while (x < args.length) {
            ps.setObject(x + 1, args[x]);
            ++x;
        }
        int r = ps.executeUpdate();
        ps.close();
        return r;
    }

    public ResultSet queryResultSet(String sql, Object ... args) throws SQLException {
        PreparedStatement ps;
        if (this.resultSetType == null || this.resultSetConcur == null) {
            if (this.connection.getMetaData().supportsResultSetConcurrency(1004, 1007)) {
                this.resultSetType = 1004;
                this.resultSetConcur = 1007;
            } else {
                this.resultSetType = 1003;
                this.resultSetConcur = 1007;
            }
        }
        this.lastPreparedStatement = ps = this.connection.prepareStatement(sql, this.resultSetType, this.resultSetConcur);
        int x = 0;
        while (x < args.length) {
            ps.setObject(x + 1, args[x]);
            ++x;
        }
        ps.execute();
        this.lastPreparedStatement = null;
        return ps.getResultSet();
    }

    public BaseStringMap queryBsm(String sql, Object ... args) throws SQLException {
        BaseStringMap bsm = new BaseStringMap();
        ResultSet rs = this.queryResultSet(sql, args);
        if (rs.next()) {
            int c = rs.getMetaData().getColumnCount();
            int x = 0;
            while (x < c) {
                String n = rs.getMetaData().getColumnName(x + 1);
                Object o = rs.getObject(x + 1);
                if (o != null) {
                    bsm.setProperty(n, o.toString());
                } else {
                    bsm.setProperty(n, (String)null);
                }
                ++x;
            }
        } else {
            bsm = null;
        }
        rs.close();
        return bsm;
    }

    public List<BaseStringMap> queryBsmListLimit(Integer limit, String sql, Object ... args) throws SQLException {
        ArrayList<BaseStringMap> l = new ArrayList<BaseStringMap>();
        ResultSet rs = this.queryResultSet(sql, args);
        while (rs.next()) {
            int c = rs.getMetaData().getColumnCount();
            BaseStringMap bsm = new BaseStringMap();
            int x = 0;
            while (x < c) {
                String n = rs.getMetaData().getColumnName(x + 1);
                Object o = null;
                try {
                    o = rs.getObject(x + 1);
                }
                catch (Exception ex) {
                    System.err.println("Error fetching col value: " + n + ": " + ex.getMessage());
                }
                if (o != null) {
                    bsm.setProperty(n, o.toString());
                } else {
                    bsm.setProperty(n, (String)null);
                }
                ++x;
            }
            l.add(bsm);
            if (l.size() >= limit) break;
        }
        rs.close();
        return l;
    }

    public List<BaseStringMap> queryBsmList(String sql, Object ... args) throws SQLException {
        ArrayList<BaseStringMap> l = new ArrayList<BaseStringMap>();
        ResultSet rs = this.queryResultSet(sql, args);
        while (rs.next()) {
            int c = rs.getMetaData().getColumnCount();
            BaseStringMap bsm = new BaseStringMap();
            int x = 0;
            while (x < c) {
                String n = rs.getMetaData().getColumnName(x + 1);
                Object o = rs.getObject(x + 1);
                if (o != null) {
                    bsm.setProperty(n, o.toString());
                } else {
                    bsm.setProperty(n, (String)null);
                }
                ++x;
            }
            l.add(bsm);
        }
        rs.close();
        return l;
    }

    public static BaseStringMap record2bsm(ResultSet rs) throws SQLException {
        BaseStringMap bsm = new BaseStringMap();
        int c = rs.getMetaData().getColumnCount();
        int x = 0;
        while (x < c) {
            String n = rs.getMetaData().getColumnName(x + 1);
            Object o = null;
            try {
                o = rs.getObject(x + 1);
            }
            catch (Exception ex) {
                String tbl = rs.getMetaData().getTableName(x + 1);
                AppLogger.error("Error fetching column data \"" + tbl + "." + n + "\"", ex);
            }
            if (o != null) {
                bsm.setProperty(n, o.toString());
            } else {
                bsm.setProperty(n, (String)null);
            }
            ++x;
        }
        return bsm;
    }

    public Integer save(String table, String pkField, BaseStringMapObject o) throws IOException, SQLException {
        Integer i = this.save(table, pkField, o.getBaseStringMap());
        EventMessage m = new EventMessage("SqlConnection.save");
        m.setProp("value", o);
        m.setProp("className", o.getClass().getName());
        MessageBus.getInstance().sendMessage(m);
        return i;
    }

    public Integer save(String table, String pkField, BaseStringMap map) throws IOException, SQLException {
        String pkVal = map.getProperty(pkField);
        if (this.getSqlDatabase().hasColumn(table, "edited").booleanValue()) {
            map.setProperty("edited", DateUtil.nowDatetime());
        }
        if (this.getSqlDatabase().hasColumn(table, "created").booleanValue() && StringUtil.isEmpty(map.getProperty("created"))) {
            map.setProperty("created", DateUtil.nowDatetime());
        }
        if (pkVal == null) {
            Integer id = this.insertRecord(table, map);
            map.setProperty(pkField, id);
            return id;
        }
        this.updateRecord(table, this.START_VAL + pkField + this.STOP_VAL + " = '" + this.escapeValue(pkVal) + "'", map);
        return NumberUtil.tryParseInt(pkVal);
    }

    public void saveOTM(String table, String refField, Integer refId, List objects) throws IOException, SQLException {
        if (objects == null || objects.size() == 0) {
            this.query("delete from " + table + " where " + refField + " = ?", refId);
            return;
        }
        SqlTable t = this.getSqlDatabase().getTable(table);
        SqlColumn pk = null;
        for (SqlColumn c : t.getColumns()) {
            if (!c.primaryKey) continue;
            pk = c;
            break;
        }
        String sql = "select * from " + table + " where " + refField + " = ? ";
        if (t.hasColumn("sort")) {
            sql = sql + " order by sort";
        }
        List oldObjs = this.queryList(sql, refId);
        int x = 0;
        while (x < objects.size()) {
            BaseStringMap rec = x < oldObjs.size() ? (BaseStringMap)oldObjs.get(x) : new BaseStringMap();
            Object o = objects.get(x);
            for (SqlColumn c : t.getColumns()) {
                if (c.primaryKey || "sort".equals(c.name) || "edited".equals(c.name) || "created".equals(c.name)) continue;
                Object v = ObjectUtil.getObjectValue(o, c.name);
                if (v instanceof java.util.Date) {
                    v = DateUtil.datetime2string((java.util.Date)v);
                }
                rec.setProperty(c.name, v == null ? null : v.toString());
            }
            rec.setProperty(refField, refId);
            if (t.hasColumn("sort")) {
                rec.setProperty("sort", x);
            }
            this.save(table, pk.name, rec);
            ++x;
        }
        if (oldObjs.size() > objects.size()) {
            x = objects.size();
            while (x < oldObjs.size()) {
                Integer id = ((BaseStringMap)oldObjs.get(x)).getPropertyInt(pk.name);
                this.query("delete from " + table + " where " + pk.name + " = ?", id);
                ++x;
            }
        }
    }

    public void saveMTM(String table, String refField, Integer refId, String objectField, List objects) throws IOException, SQLException {
        if (objects == null || objects.size() == 0) {
            this.query("delete from " + table + " where " + refField + " = ?", refId);
            return;
        }
        SqlTable t = this.getSqlDatabase().getTable(table);
        SqlColumn pk = null;
        for (SqlColumn c : t.getColumns()) {
            if (!c.primaryKey) continue;
            pk = c;
            break;
        }
        String sql = "select * from " + table + " where " + refField + " = ? ";
        if (t.hasColumn("sort")) {
            sql = sql + " order by sort";
        }
        List oldObjs = this.queryList(sql, refId);
        int x = 0;
        while (x < objects.size()) {
            BaseStringMap bsm = x < oldObjs.size() ? (BaseStringMap)oldObjs.get(x) : new BaseStringMap();
            Object o = ObjectUtil.getObjectValue(objects.get(x), objectField);
            if (o != null) {
                bsm.setProperty(objectField, o.toString());
                bsm.setProperty(refField, refId);
                if (t.hasColumn("sort")) {
                    bsm.setProperty("sort", x);
                }
                this.save(table, pk.name, bsm);
            }
            ++x;
        }
        if (oldObjs.size() > objects.size()) {
            x = objects.size();
            while (x < oldObjs.size()) {
                Integer id = ((BaseStringMap)oldObjs.get(x)).getPropertyInt(pk.name);
                this.query("delete from " + table + " where " + pk.name + " = ?", id);
                ++x;
            }
        }
    }

    public String escapeValue(String str) {
        return str.replace("'", "\\'");
    }

    public int updateRecord(String table, String sqlWhere, BaseStringMap map) throws IOException, SQLException {
        SqlTable sqlTable = this.getSqlDatabase().getTable(table);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder str = new StringBuilder();
        str.append("UPDATE ").append(sqlTable.getTableRef());
        str.append(" SET ");
        Set<String> keys = map.getMap().keySet();
        int colCount = 0;
        for (String k : keys) {
            int maxColLen;
            SqlColumn sqlCol = sqlTable.getColumnByName(k);
            if (sqlCol == null || sqlCol.primaryKey) continue;
            if (colCount > 0) {
                str.append(", ");
            }
            str.append(this.START_VAL).append(sqlCol.name).append(this.STOP_VAL).append(" = ?");
            String colval = map.getProperty(k);
            if (colval != null && this.autoTruncate && (maxColLen = sqlTable.getColumnByName((String)k).maxLen) != -1 && colval.length() > maxColLen) {
                colval = colval.substring(0, maxColLen);
            }
            params.add(this.castColValue(sqlTable.getColumn(k), colval));
            ++colCount;
        }
        str.append(" WHERE ").append(sqlWhere);
        return this.queryUpdate(str.toString(), params.toArray());
    }

    public void truncateTable(String tblname) throws SQLException {
        this.query("truncate table " + tblname, new Object[0]);
    }

    public abstract void connect() throws SQLException, InvalidStateException;

    public void validateConnection() throws SQLException, InvalidStateException {
        if (this.connection == null) {
            this.connect();
        } else if (!this.connection.isValid(2500)) {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.connect();
        }
    }

    public void close() throws SQLException {
        this.connection.close();
    }

    public void cancelLastStatement() throws SQLException {
        if (this.lastPreparedStatement != null) {
            this.lastPreparedStatement.cancel();
        }
    }
}

